#pragma once

#include "Component.h"
#include "ListBox.h"

/**
 * @class ChartLegend
 * @brief A UI component that displays a legend for chart series.
 *
 * Each item in the legend corresponds to a chart series or value,
 * showing a label and associated color.
 */
class ChartLegend : public Component
{
	ListBox _list;

protected:
	/**
	 * @brief Retrieves options for creating the legend window.
	 *
	 * @param title Output: window title.
	 * @param widownStyles Output: window style flags.
	 * @param wndClassName Output: window class name.
	 * @param isCustomWndProc Output: whether a custom window procedure is used.
	 * @return TRUE if options were successfully retrieved, FALSE otherwise.
	 */
	BOOL getCreateWindowOptions(wstring& title, UINT& widownStyles, wstring& wndClassName, BOOL& isCustomWndProc);

	/**
	 * @brief Called after the legend window has been successfully created.
	 */
	void windowCreated();

public:
	/**
	 * @brief Constructs a new ChartLegend instance.
	 */
	ChartLegend();

	/**
	 * @brief Destroys the ChartLegend and its internal structures.
	 */
	virtual ~ChartLegend();

	/**
	 * @brief Clears all items from the legend.
	 */
	void clear();

	/**
	 * @brief Adds a new item to the legend.
	 *
	 * @param text The label text for the legend item.
	 * @param color The color associated with the legend item.
	 */
	void addLegendValue(const wstring& text, COLORREF color);

	/**
	 * @brief Called when the legend window is resized.
	 */
	void onWindowResized();
};
