#pragma once

#include <string>
using namespace std;

/**
 * @class Encryption
 * @brief Provides static methods for encrypting and decrypting wide strings.
 *
 * This utility class offers simple static methods to encrypt and decrypt text data
 * using a provided key. The encryption and decryption algorithms are symmetric,
 * meaning the same key is used for both operations.
 */
class Encryption
{
public:

    /**
     * @brief Encrypts the given input string using the specified key.
     *
     * @param input The plain text wide string to encrypt.
     * @param key The key used for encryption.
     * @return The encrypted wide string.
     */
    static wstring encrypt(const wstring& input, const wstring& key);

    /**
     * @brief Decrypts the given encrypted string using the specified key.
     *
     * @param input The encrypted wide string to decrypt.
     * @param key The key used for decryption (must be the same as the encryption key).
     * @return The decrypted plain text wide string.
     */
    static wstring decrypt(const wstring& input, const wstring& key);

    static string base64_encode(const string& in);
    static string base64_decode(const string& in);
};
