#pragma once

#include <iostream>
#include <string>
#include <algorithm>
#include <unordered_map>
#include <cwctype>
#include <cmath>
#include <stdexcept>

class ExpressionEvaluator {

	std::wstring expression;
	std::unordered_map<std::wstring, double> variables;
	size_t pos;
	std::wstring token;
	std::wstring lastError;
	enum class TokenType { NONE, NUMBER, VARIABLE, OPERATOR, LPAREN, RPAREN, END } tokenType;

public:

	bool compile(const std::wstring& expr);
	bool evaluate(const std::unordered_map<std::wstring, double>& vars, double& result);
	std::wstring getLastError();

private:

	void skipWhitespace();

	std::wstring toLowerCase(const std::wstring& input);

	bool nextToken();
	bool expect(TokenType expectedType, const std::wstring& expectedToken = L"");
	bool parseExpression(double& result);
	bool parseTerm(double& result);
	bool parseFactor(double& result);
	bool parsePrimary(double& result);
};
