#pragma once

#include "Component.h"

enum class MenuItemType {
    Invalid = 0,
    TextItem = 1,
    PopupItem = 2,
    SeparatorItem = 3
};

class Menu;
class MenuItem
{
public:
    MenuItemType _itemType;
    long _actionId;     // Identifier for the menu action (used in event handling)
    wstring _text;      // Text to display on the menu item
    Menu *_popupItem;

    MenuItem();
    virtual ~MenuItem();
};

class Menu
{
    MenuHandle _hMenu;              // Native Windows menu handle

public:

    wstring _menuName;
    vector<MenuItem *> _items;        // List of menu items (commands or separators)
    Bounds _menuNameRect;

    Menu();
    virtual ~Menu();

    MenuHandle getHandle();

    void addTextItem(long actionId, const wstring& text);
    Menu* addPopupItem(const wstring& text);
    void addSeparatorItem();
};

class MenuBar : public Component
{
    MenuHandle _hMenuBar;          // Handle to the native Windows menu bar
    vector<Menu *> _menus;      // Collection of menus attached to this menu bar

protected:

    BOOL getCreateWindowOptions(wstring& title, UINT& widownStyles, wstring& wndClassName, BOOL& isCustomWndProc);

    void windowCreated();

public:

    MenuBar();
    virtual ~MenuBar();

    /**
     * Adds a new menu to the menu bar.
     * @param menuName The display name of the menu (e.g., "File").
     */
    Menu* addMenu(const wstring& menuName);

    /**
     * Sets the constructed menu bar on a window.
     * @param hWnd Handle to the window on which to set the menu.
     */
    void setMenu(WinHandle hWnd);

public:

    int getPreferredHeight();

    void onPaint(Graphics* g);

    void onWindowResized();

    void onMousePressed(WinHandle hWnd, int x, int y, int clickCount, BOOL shiftPressed, BOOL ctrlPressed);
    void onMouseMoved(WinHandle hWnd, int x, int y, BOOL shiftPressed, BOOL ctrlPressed);

    void addActionListener(ActionListener* l);
};
