#pragma once

#include "Component.h"
#include "Label.h"

class PanelBaseChild
{
public:
    int _column;        
    int _row;           
    int _columnCount;   
    int _rowCount;      
    int _x;             
    int _y;             
    int _width;         
    int _height;        
    Component* _component; 
    wstring _labelText;    
    Label* _label;         
};

/**
 * @brief Base class for panel-like components that arrange child components in a grid layout.
 * 
 * Inherits from Component. Manages a collection of child components and their layout,
 * and handles common window messages such as actions, selections, and drawing.
 */
class PanelBase : public Component
{
protected:

    std::vector<PanelBaseChild> _children;  /**< List of child components with layout info */

    HDWP _hDwp;

    BOOL isScrollingSupported();

    /**
     * @brief Retrieves window creation options such as window title, styles, and class name.
     * 
     * @param title Reference to store window title.
     * @param widownStyles Reference to store window styles.
     * @param wndClassName Reference to store window class name.
     * @param isCustomWndProc Reference to store whether a custom window procedure is used.
     * @return BOOL TRUE if successful, FALSE otherwise.
     */
    BOOL getCreateWindowOptions(wstring& title, UINT& widownStyles, wstring& wndClassName, BOOL& isCustomWndProc);

    /**
     * @brief Gets the class name for the window. Must be implemented by derived classes.
     * 
     * @return wstring Window class name.
     */
    virtual wstring getClassName() = 0;

public:

    BOOL getChildren(vector<Component*>& children);

public:
    /**
     * @brief Constructs a PanelBase instance.
     */
    PanelBase();

    /**
     * @brief Virtual destructor to clean up resources.
     */
    virtual ~PanelBase();

    /**
     * @brief Called when the panel window has moved.
     */
    void onWindowMoved();
};
