#pragma once

#include "Component.h"
#include "CheckList.h"
#include "Button.h"

/**
 * @class PickList
 * @brief A complex component used to copy items between lists.
 */
class PickList : public Component,
                 public ActionListener
{
    CheckList _selectableItemsList, _selectedItemsList;
    Button _buttonAdd, _buttonAddAll;         ///< Button to add selected items
    Button _buttonDelete, _buttonDeleteAll;      ///< Button to delete selected items
 
    vector<KeyValue> _selectableItems;
    vector<KeyValue> _selectedItems;

    /**
     * @brief Creates child components within the given parent window handle.
     * @param hParent The handle of the parent window.
     */
    void createChildren(Component *parent);

protected:
    /**
     * @brief Provides window creation options specific to this component.
     * @param title Window title string (output).
     * @param widownStyles Window style flags (output).
     * @param wndClassName Window class name string (output).
     * @param isCustomWndProc TRUE if a custom window procedure is used (output).
     * @return TRUE if options were successfully provided.
     */
    BOOL getCreateWindowOptions(wstring& title, UINT& widownStyles, wstring& wndClassName, BOOL& isCustomWndProc);

    /**
     * @brief Called after the native window is created; initializes child components.
     */
    void windowCreated();

public:
    PickList();
    virtual ~PickList();

    void setSelectableItems(const vector<KeyValue> & items);
    void setSelectedItems(const vector<KeyValue>& items);
    void getSelectedItems(vector<KeyValue>& items);

    /**
     * @brief Called when the window is resized; adjusts layouts.
     */
    void onWindowResized();

    /**
     * @brief Called to paint the PickList component.
     * @param hDC Handle to the device context.
     */
    void onPaint(Graphics *g);

    /**
     * @brief Handles actions triggered by buttons or other components.
     * @param ev The action event describing the source and action.
     */
    void onAction(const ActionEvent& ev);
};
