#pragma once

#include "Button.h"

class RichText: public Component, public ActionListener
{
    WinHandle _hRichTextWnd;
    Button _boldBtn, _italicBtn, _underlineBtn, _fontNameBtn, _fontSizeBtn, 
            _alignLeftBtn, _alignRightBtn, _alignCenterBtn, _printBtn;

    long _buttonsRowHeight;
    BOOL _readOnly;
    int _maxLength;

    wstring _formattedText, _text;

protected:
    /**
     * @brief Retrieves window creation options.
     * 
     * @param title Reference to window title.
     * @param widownStyles Reference to window styles.
     * @param wndClassName Reference to window class name.
     * @param isCustomWndProc Reference to custom window procedure flag.
     * @return TRUE if successful, FALSE otherwise.
     */
    BOOL getCreateWindowOptions(wstring& title, UINT& widownStyles, wstring& wndClassName, BOOL& isCustomWndProc);

    /**
     * @brief Called when the window is created.
     */
    void windowCreated();

public:
    /**
     * @brief Constructs a new RichText component.
     */
    RichText();

    /**
     * @brief Destructor for the RichText component.
     */
    virtual ~RichText();

    /**
     * @brief Clears all panels.
     */
    void clear();

    void setReadOnly(BOOL readOnly);

    void setMaxLength(int maxLen);

    wstring getFormattedText();
    void setFormattedText(const wstring& rtfText);

    wstring getText();
    void setText(const wstring& plainText);

    wstring getSelectedText();
//    void replaceSelectedText(const wstring& newText);

    BOOL toggleSelectedTextStyling(DWORD mask, DWORD effect);
    BOOL alignSelectedText(int alignment/*-1: left, 0: center, 1: right*/);
    BOOL setSelectedTextFontName(const wstring& fontName);
    BOOL setSelectedTextFontSize(long fontSize);

    BOOL selectText(const wstring& textToFind);

    BOOL canUndo();
    BOOL undo();
    BOOL canRedo();
    BOOL redo();

    BOOL print();

    /**
     * @brief Handles window resize events.
     */
    void onWindowResized();

    /**
     * @brief Paints the RichText including panels and active content.
     * 
     * @param hDC Device context handle.
     */
    void onPaint(Graphics *g);

    void onAction(const ActionEvent& ev);

    void addDataChangedListener(DataChangeListener* l);

public:

    void onDataChanged(WinHandle hTarget, const wstring& newValue, const ProcParams& procParams);
};
