#pragma once

#include <string>
#include <iostream>
#include <sstream>
#include <vector>
#include <algorithm>
#include <cctype>
#include <cwctype>
using namespace std;

/**
 * @class StringHelpers
 */
class StringHelpers
{
public:

    static string wstringTostring(const wstring& wstr);
    static wstring stringTowstring(const string& str);

    static wstring wstringToUppercase(const wstring& input);
    static string stringToUppercase(const string& input);
    static wstring wstringToLowercase(const wstring& input);
    static string stringToLowercase(const string& input);

    static wstring wstringTrim(const wstring& input);
    static wstring wstringTrimLeft(const wstring& input);
    static wstring wstringTrimRight(const wstring& input);
    static string stringTrim(const string& input);
    static string stringTrimLeft(const string& input);
    static string stringTrimRight(const string& input);

    static int wstringFindExact(const wstring& input, const wstring& strToFind, int startFrom = 0);
    static int wstringFindFirstAnyOf(const wstring& input, const wstring& strToFind, int startFrom = 0);
    static int wstringFindLastAnyOf(const wstring& input, const wstring& strToFind, int startFrom = 0);
    static int stringFindExact(const string& input, const string& strToFind, int startFrom = 0);
    static int stringFindFirstAnyOf(const string& input, const string& strToFind, int startFrom = 0);
    static int stringFindLastAnyOf(const string& input, const string& strToFind, int startFrom = 0);

    static wstring wstringLeft(const wstring& input, int count = -1);
    static wstring wstringMiddle(const wstring& input, int startIndex, int count = -1);
    static wstring wstringRight(const wstring& input, int count = -1);
    static string stringLeft(const string& input, int count = -1);
    static string stringMiddle(const string& input, int startIndex, int count = -1);
    static string stringRight(const string& input, int count = -1);

    static vector<wstring> wstringTokenize(const wstring& input, wchar_t delimiter);
    static vector<string> stringTokenize(const string& input, char delimiter);
};
