#pragma once

#include "PanelBase.h"
#include "CardPanel.h"

class TabBarItem
{
public:
    TabBarItem(const wstring& title, PanelBase*tabComponent)
    {
        _title = title;
        _tabComponent = tabComponent;
    }

    wstring _title;          
    PanelBase* _tabComponent;
    Bounds _rect;              
};

/**
 * @brief A component that manages multiple tabs with associated content components.
 */
class TabPane: public Component
{
    WinHandle _hWnd;                 /**< Window handle */
    CardPanel _cardPanel;       /**< Panel managing tab content */

    long _tabBarHeight;         /**< Height of the tab bar */

    vector<TabBarItem> _tabs;   /**< List of tabs */
    long _firstVisibleTab;      /**< Index of the first visible tab */
    long _lastVisibleTab;       /**< Index of the last visible tab */
    long _selectedTab;          /**< Index of the currently selected tab */

    BOOL _paintTabsBackward;    /**< Flag to paint tabs in reverse order */
    Bounds _scrollLeftBtnRect;    /**< Rectangle for scroll left button */
    Bounds _scrollRightBtnRect;   /**< Rectangle for scroll right button */

protected:
    /**
     * @brief Retrieves window creation options.
     * 
     * @param title Reference to window title.
     * @param widownStyles Reference to window styles.
     * @param wndClassName Reference to window class name.
     * @param isCustomWndProc Reference to custom window procedure flag.
     * @return TRUE if successful, FALSE otherwise.
     */
    BOOL getCreateWindowOptions(wstring& title, UINT& widownStyles, wstring& wndClassName, BOOL& isCustomWndProc);

    /**
     * @brief Called when the window is created.
     */
    void windowCreated();

public:
    /**
     * @brief Constructs a new TabPane component.
     */
    TabPane();

    /**
     * @brief Destructor for the TabPane component.
     */
    virtual ~TabPane();

    /**
     * @brief Clears all tabs.
     */
    void clear();

    /**
     * @brief Adds a new tab with the specified title and component.
     * 
     * @param tabTitle The title of the tab.
     * @param tabComponent The component to display when the tab is active.
     */
    void addTab(const wstring& tabTitle, PanelBase* tabComponent);

    /**
     * @brief Handles window resize events.
     */
    void onWindowResized();

    /**
     * @brief Paints the TabPane including tabs and active content.
     * 
     * @param hDC Device context handle.
     */
    void onPaint(Graphics *g);

    /**
     * @brief Handles mouse press events.
     * 
     * @param hWnd Handle to the window.
     * @param x X coordinate of the mouse.
     * @param y Y coordinate of the mouse.
     * @param clickCount Number of clicks.
     * @param shiftPressed TRUE if shift key pressed.
     * @param ctrlPressed TRUE if ctrl key pressed.
     */
    void onMousePressed(WinHandle hWnd, int x, int y, int clickCount, BOOL shiftPressed, BOOL ctrlPressed);
};
