#pragma once

#include "Component.h"
#include "Button.h"

class TitleBar : public Component, public ActionListener
{
    Button _minimizeBtn, _maximizeRestoreBtn, _closeBtn;

    Bounds _iconRect;
    IconSource _iconSource;

    Bounds _parentOriginalRect;
    BOOL _parentOriginalRectSet;
    BOOL _parentIsMaximized;

    wstring _text;

    BOOL _dragging;
    POINT _dragStart;

protected:

    BOOL getCreateWindowOptions(wstring& title, UINT& widownStyles, wstring& wndClassName, BOOL& isCustomWndProc);

    void windowCreated();

public:

    TitleBar();
    virtual ~TitleBar();

    void setIcon(const IconSource& iconSource);

    void setText(const wstring& text);

    int getPreferredHeight();

    void onPaint(Graphics* g);

    void onWindowResized();

    void onMousePressed(WinHandle hWnd, int x, int y, int clickCount, BOOL shiftPressed, BOOL ctrlPressed);
    void onMouseReleased(WinHandle hWnd, int x, int y, BOOL shiftPressed, BOOL ctrlPressed);
    void onMouseMoved(WinHandle hWnd, int x, int y, BOOL shiftPressed, BOOL ctrlPressed);

    void onAction(const ActionEvent& ev);
};
