#pragma once

#include "Component.h"
#include "ToolTip.h"

/**
 * @class ToastFactory
 * @brief A utility class providing static methods to show common toast messages.
 *
 * This factory class offers convenient static methods to display error, warning,
 * info, and success messages.
 */
class ToastFactory
{
    static ToolTip _toast;

    static void createToast(Component *parent);

public:
    /**
     * @brief Shows an error message toast.
     *
     * @param hParent Handle to the parent window.
     * @param errorMessage The error message to display.
     * @param title Optional toast title. Defaults to an empty string.
     */
    static void showError(Component *parent, const wstring& errorMessage, const wstring& title = L"");

    /**
     * @brief Shows a warning message toast.
     *
     * @param hParent Handle to the parent window.
     * @param warningMessage The warning message to display.
     * @param title Optional toast title. Defaults to an empty string.
     */
    static void showWarning(Component *parent, const wstring& warningMessage, const wstring& title = L"");

    /**
     * @brief Shows an informational message toast.
     *
     * @param hParent Handle to the parent window.
     * @param infoMessage The informational message to display.
     * @param title Optional toast title. Defaults to an empty string.
     */
    static void showInfo(Component *parent, const wstring& infoMessage, const wstring& title = L"");

    /**
     * @brief Shows a success message toast.
     *
     * @param hParent Handle to the parent window.
     * @param successMessage The success message to display.
     * @param title Optional toast title. Defaults to an empty string.
     */
    static void showSuccess(Component *parent, const wstring& successMessage, const wstring& title = L"");
};

