#pragma once

#include <Windows.h>
#include <string>
#include <vector>
using namespace std;

class ZipFile
{
	void* _zipHandle;

	BOOL _isWriteMode;
	string _lastError;

public:

	ZipFile();
	virtual ~ZipFile();

	static BOOL CreateZipFromFiles(const string& outputZipFilePath, const vector<string>& files);
	static BOOL ExtractZip(const string& zipFilePath, const string& outputDir);

	BOOL Create(const string& filePath, BOOL overwriteContent = FALSE);
	BOOL Open(const string& filePath);
	void Close();

	BOOL AddEntryFromFile(const string& relativePathInZip, const string& inputFilePath);
	BOOL AddEntryFromMemory(const string& relativePathInZip, const char* inputData, size_t inputDataSize);
	BOOL ExtractFileToFile(const string& relativePathInZip, const string& outputFilePath);
	BOOL ExtractFileToMemory(const string& relativePathInZip /* "test/test-1.txt" */, string& outputBuf);

	long EntriesCount();

	string getLastError();
};