#include <include/Frame.h>
#include <include/CardPanel.h>
#include <include/DialogFactory.h>
#include <include/Icons.h>
#include <include/EventListeners.h>

#include "framework.h"
#include "SavvyUIApp_VC2022.h" // Rename to your application's name

class MainFrame : public Frame, public ActionListener
{
	CardPanel _cardPanel;

public:

	MainFrame(const wstring& title) : Frame(title)
	{
		Theme::GetInstance()->setDarkTheme(); // setSilverTheme()

		setLicense(L"Set Your License String Here!!!");
	}


	void onConstructWindow()
	{
		setWindowCentered();

		// Add the child components
		Bounds clientRect;
		GetClientRect(clientRect);

		GridPanel* contentPane = getContentPane();
		contentPane->setLayout({ 5, -1, 5 }, { 5, -1, 5 });
		contentPane->addComponent(CreateCardPanel(contentPane, clientRect), 1, 1);
        //
        setIcon(IconSource(IconType::CALCULATOR));
        //
        Menu* fileMenu = addMenu(L"File");
        if (fileMenu)
        {
            fileMenu->addTextItem(10, L"New");
            fileMenu->addTextItem(11, L"Open");
            Menu* saveAsMenu = fileMenu->addPopupItem(L"Save As Image");
            if (saveAsMenu)
            {
                saveAsMenu->addTextItem(10291, L"PNG");
                saveAsMenu->addTextItem(10292, L"JPG");
                saveAsMenu->addTextItem(10292, L"GIF");
            }
            fileMenu->addTextItem(12, L"close");
            fileMenu->addSeparatorItem();
            fileMenu->addTextItem(13, L"Exit");
        }
        Menu* editMenu = addMenu(L"Edit");
        if (editMenu)
        {
            editMenu->addTextItem(21, L"Copy");
            editMenu->addTextItem(22, L"Paste");
            editMenu->addTextItem(23, L"Cut");
            editMenu->addTextItem(24, L"Select All");
        }
        setMenuBarListener(this);
    }

    void onAction(const ActionEvent& ev)
    {
        if (ev.actionId == 10)
        {
            DialogFactory::showInfo(this, L"File->New action");
        }
        else if (ev.actionId == 10291)
            DialogFactory::showInfo(this, L"File->Save As PNG");
    }

	Component* CreateCardPanel(Component *parent, Bounds rect)
	{
		_cardPanel.createComponent(parent, rect);

		return &_cardPanel;
	}
};

//============================================= Main Entry Function =========================================

#define MAX_LOADSTRING 100

int APIENTRY wWinMain(_In_ HINSTANCE hInstance,
	_In_opt_ HINSTANCE hPrevInstance,
	_In_ LPWSTR    lpCmdLine,
	_In_ int       nCmdShow)
{
	UNREFERENCED_PARAMETER(hPrevInstance);
	UNREFERENCED_PARAMETER(lpCmdLine);

	long screenWidth, screenHeight;
	UICommonUtils::getScreenSize(screenWidth, screenHeight);

	Bounds rect;
	rect.left = 0;
	rect.top = 0;
	rect.right = screenWidth > 1400 ? 1400 : screenWidth;
	rect.bottom = screenHeight > 800 ? 800 : screenHeight;

	MainFrame frame(L"SavvyUI Sample");
	return frame.show(rect.left, rect.top, rect.width(), rect.height());
}
