#pragma once

#include "Component.h"
#include "Button.h"

class AccordionPanel
{
public:

    Button _button;
    Component* _component;

    wstring _title;
    UINT _id;
    BOOL _isVisible;
};

/**
 * @class Accordion
 * @brief A UI component that manages multiple collapsible panels, allowing single or multiple panel selection.
 * 
 * The Accordion class extends Component and implements ActionListener to provide
 * functionality for handling multiple panels where each panel can contain a UI component.
 */
class Accordion : public Component, public ActionListener
{
    BOOL _singleSelection; ///< If TRUE, only one panel can be expanded at a time.
    vector<AccordionPanel> _panels; ///< List of panels contained in the Accordion.
    long _selectedPanelId;

protected:
    /**
     * @brief Prepares window creation options such as title, styles, and class name.
     * 
     * @param title The window title to set.
     * @param widownStyles Window style flags.
     * @param wndClassName The window class name.
     * @param isCustomWndProc Indicates if a custom window procedure is used.
     * @return TRUE if the options were set successfully, FALSE otherwise.
     */
    BOOL getCreateWindowOptions(wstring& title, UINT& widownStyles, wstring& wndClassName, BOOL& isCustomWndProc);

    /**
     * @brief Called after the window has been created to perform any initialization.
     */
    void windowCreated();

public:
    /**
     * @brief Constructs an Accordion object.
     */
    Accordion();

    /**
     * @brief Destructs the Accordion object and cleans up resources.
     */
    virtual ~Accordion();

    /**
     * @brief Adds a new panel to the Accordion.
     * 
     * @param title The title of the panel.
     * @param component The UI component contained within the panel.
     */
    void addPanel(const wstring& title, Component *component);

    /**
     * @brief Handles the painting of the Accordion.
     * 
     * @param hDC Handle to the device context to paint on.
     */
    void onPaint(Graphics *g);

    /**
     * @brief Responds to the window being resized.
     */
    void onWindowResized();

public:
    /**
     * @brief Handles action events triggered by the Accordion or its components.
     * 
     * @param ev The action event information.
     */
    void onAction(const ActionEvent& ev);
};
