#pragma once
#include "Common.h"
#include "Graphics.h"

class ChartValue
{
public:

	ChartValue(const wstring& text, double value, COLORREF color)
	{
		_text = text;
		_value = value;
		_color = color;
	}

	wstring _text;
	double _value;
	COLORREF _color;
};

class ChartSeries
{
public:

	wstring _name;
	vector<ChartValue> _values;
	COLORREF _color;
};

class ChartUtil
{
	static void drawPie(Graphics *g, Bounds rect, double startAngle, double sweepAngle, COLORREF color, const wstring& label, BOOL isDonut = FALSE);

public:

	static void drawLineChart(Graphics *g, Bounds rect, const vector<ChartSeries>& series, COLORREF color);
	static void drawAreaChart(Graphics *g, Bounds rect, const vector<ChartSeries>& series, COLORREF color);
	static void drawBarChart(Graphics *g, Bounds rect, const vector<ChartSeries>& series);
	static void drawPieChart(Graphics *g, Bounds rect, const vector<ChartValue>& values, BOOL isDonut = FALSE); // Only 1 series is supported
	static void drawFunnelChart(Graphics *g, Bounds rect, const vector<ChartValue>& values); // Only 1 series is supported
	static void drawRadarChart(Graphics *g, Bounds rect, const vector<ChartSeries>& series);
	static void drawScatterChart(Graphics *g, Bounds rect, const vector<ChartSeries>& series);
	static void drawHeatmapChart(Graphics *g, Bounds rect, const vector<ChartSeries>& series);
};