#pragma once

#include <Windows.h>
#include <windowsx.h>
#include <commdlg.h>
#include <ole2.h>
#include <stdio.h>
#include <gdiplus.h>
#include <string>
#include <vector>
#include <map>
using namespace std;

#define PI 3.14159265358979323846

typedef HWND	WinHandle;
typedef HDC		DCHandle;
typedef HMENU	MenuHandle;

class Bounds
{
public:

	Bounds()
	{
		left = 0;
		top = 0;
		right = 0;
		bottom = 0;
	}

	Bounds(long l, long t, long r, long b)
	{
		left = l;
		top = t;
		right = r;
		bottom = b;
	}

	void setWidth(long w)
	{
		right = left + w - 1;
	}

	void setHeight(long h)
	{
		bottom = top + h - 1;
	}

	void deflateRect(long numPixels)
	{
		long xPixels = numPixels;
		while (xPixels > 0)
		{
			if (left >= right)
				break;
			left++;

			if (right > left)
				right--;
			xPixels--;
		}
		long yPixels = numPixels;
		while (yPixels > 0)
		{
			if (top >= bottom)
				break;
			top++;

			if (bottom > top)
				bottom--;
			yPixels--;
		}
	}

	void inflateRect(long numPixels)
	{
		long xPixels = numPixels;
		while (xPixels > 0)
		{
			if (left > 0)
				left--;
			else
				break;

			right++;
			xPixels--;
		}
		long yPixels = numPixels;
		while (yPixels > 0)
		{
			if (top > 0)
				top--;
			else
				break;

			bottom++;
			yPixels--;
		}
	}

	long width() const
	{
		return right - left;
	}

	long height() const
	{
		return bottom - top;
	}

	BOOL contains(long x, long y)
	{
		if (right > left && bottom > top)
			return (x >= left && x <= right && y >= top && y <= bottom);
		return FALSE;
	}

	long left, top, right, bottom;
};

enum class Direction {
	LEFT = 1,
	TOP = 2,
	RIGHT = 3,
	BOTTOM = 4
};

enum class ImageAlignment {
	TOPLEFT = 1,
	TOPCENTER = 2,
	TOPRIGHT = 3,
	MIDDLELEFT = 4,
	MIDDLECENTER = 5,
	MIDDLERIGHT = 6,
	BOTTOMLEFT = 7,
	BOTTOMCENTER = 8,
	BOTTOMRIGHT = 9
};

enum class ImageType {
	PNG = 1,
	GIF = 2,
	JPG = 3
};

enum class EditType {
	TEXTFIELD = 1,
	MASKEDFIELD = 2,
	NUMBERFIELD = 3,
	DATEFIELD = 4,
	DATETIMEFIELD = 5,
	COMBOBOXFIELD = 6,
	TEXTAREAFIELD = 7,
	BOOLFIELD = 8,
	COMPUTED = 9
};

enum class ButtonType {
	DEFAULT = 1,
	PRIMARY = 2,
	INFO = 3,
	DANGER = 4,
	SUCCESS = 5,
	WARN = 6,
	GRAY = 7,
	LIGHTGRAY = 8,
	BLUE = 9,
	LIGHTBLUE = 10,
	TEAL = 11,
	CYAN = 12,
	PINK = 13,
	INDIGO = 14,
	ORANGE = 15,
	BROWN = 16,
	SILVER = 17,
	RED = 18,
	WINDOW = 19,
	CUSTOM = 20
};

enum class ChartType {
	BAR = 1,
	PIE = 2,
	DONUT = 3,
	AREA = 4,
	LINE = 5,
	FUNNEL = 6,
	RADAR = 7,
	SCATTER = 8,
	HEATMAP = 9
};

class KeyValue
{
public:

	KeyValue(const wstring& key, const wstring& value)
	{
		_key = key;
		_value = value;
	}
	wstring _key;
	wstring _value;
};

class NumberCollection
{
public:
	__int64 _value1;
	__int64 _value2;
	__int64 _value3;
	__int64 _value4;
	__int64 _value5;
	__int64 _value6;
	__int64 _value7;
	__int64 _value8;
	__int64 _value9;
	__int64 _value10;
};

class CommonUtils
{
public:

	static wstring strToWStr(const char* input);
	static string wStrToStr(const wchar_t* input);

	static RECT SRectToRECT(const Bounds& rect);

public:

	static BOOL getExeName(wstring& filePath, BOOL returnFileNameOnly);
	static BOOL getExeFolder(wstring& exeDir);

public:

	static BOOL copyFile(const wstring& srcFilePath, const wstring& destFilePath, BOOL failIfExists = TRUE, BOOL createDirectoryIfNotExists = TRUE);
	static BOOL getFileSize(const wstring& filePath, DWORD& fileSize);
	static BOOL getDirFromPath(const wstring& filePath, wstring& directory);
	static BOOL getPathComponents(const wstring& filePath, wstring& directory, wstring& fileName, wstring& fileExtension);
	static BOOL createDirectory(const wstring& directory);

	static BOOL readFile(FILE* fp, void* buffer, size_t size, DWORD atOffset);
	static BOOL writeFile(FILE* fp, void* buffer, size_t size, DWORD atOffset);

public:

	static BOOL createShortcut(const wchar_t* targetPath);

	static BOOL addRegistryEntry(const wchar_t* valueName, const wchar_t* valueData, const wchar_t* subKeyPath, HKEY hSection = HKEY_CURRENT_USER);
	static BOOL executeSystemCommand(const wchar_t* command, const wchar_t* parameters, const wchar_t* workingDirectory, BOOL waitForCompletion = FALSE);

public:

	static BOOL isDigit(wchar_t ch);
	static BOOL isAlpha(wchar_t ch);
	static BOOL isDigitOrAlpha(wchar_t ch);

	static wstring systemTimeToStrYYYYMMDD(const SYSTEMTIME& sysTime);
	static SYSTEMTIME strYYYYMMDDToSystemTime(const wstring& strYYYYMMDD);
};

