#pragma once
#include <vector>
#include <string>
using namespace std;

class Database
{
	void* _db;

public:

	Database();
	virtual ~Database();

	bool open(const wstring& filePath);
	void close();

	bool isConnected();

	bool execQuery(const wstring& wSqlStr, wstring& errorMsg, vector<vector<wstring>>& results);
	bool execQueryPaged(const wstring& wSqlStrWithoutLimitAndOrderBy, 
						int pageSize, __int64 startRow,
						const wstring& sortByColumnName, bool isDescending,
						wstring& errorMsg, vector<vector<wstring>>& results, __int64& totalRowCount);
	bool execNonQuery(const wstring& wSqlStr, wstring& errorMsg);
};