#pragma once

#include "Common.h"

//===========================================================================================
class DataChangeEvent
{
public:
    long sourceComponentId;
    wstring oldValue;      
    wstring newValue;      
};

class DataChangeListener
{
public:
    virtual void onDataChanged(const DataChangeEvent& ev) = 0;
};

//===========================================================================================
class SelectionChangeEvent
{
public:
    long sourceComponentId;  
    __int64 selectionIndex;  
    wstring selectionValue;  
    BOOL checked;            
};

class SelectionChangeListener
{
public:
    virtual void onSelectionChanged(const SelectionChangeEvent& ev) = 0;
};

//===========================================================================================
class ActionEvent
{
public:
    long sourceComponentId;
    __int64 actionId;      
    wstring actionName;    
};

class ActionListener
{
public:
    virtual void onAction(const ActionEvent& ev) = 0;
};

//===========================================================================================
class RowDoubleClickEvent
{
public:
    long sourceComponentId;  
    __int64 rowIndex;        
};

class RowDoubleClickListener
{
public:
    virtual void onItemDoubleClicked(const RowDoubleClickEvent& ev) = 0;
};

//===========================================================================================
class GridViewListener
{
public:
    virtual void onCreateItem(long sourceId) = 0;

    virtual void onEditItem(long sourceId, __int64 rowIndex) = 0;

    virtual BOOL onDeleteItem(long sourceId, __int64 rowIndex) = 0;

    virtual void onItemCreated(long sourceId, __int64 rowIndex, const vector<KeyValue>& rowValues) = 0;

    virtual void onItemUpdated(long sourceId, __int64 rowIndex, const vector<KeyValue>& rowValues) = 0;
};

//===========================================================================================
class GridChangeListener
{
public:

    virtual BOOL onCellValueChanged(long sourceId, __int64 rowIndex, const wstring& columnName,
        const wstring& oldValue, const wstring& newValue) = 0;
};

