#pragma once

#include "Common.h"
#include "Graphics.h"

class Icons
{
	BOOL ezIconDisabled;
	BOOL fillModeEnabled;
	BOOL isMonotone;
	COLORREF fillColor;
	COLORREF textColor;
	COLORREF borderColor;
	long maxImageSize;

public:

	Icons();

	void disableEzIcon(BOOL bDisabled = TRUE);
	void enableFillMode(BOOL bEnabled = TRUE);
	void enableMonotone(BOOL bEnabled = TRUE);
	void setColor(COLORREF color = RGB(51, 102, 152));
	void setTextColor(COLORREF color = RGB(0,0,0));
	void setBorderColor(COLORREF color = RGB(0,0,0));
	void setMaxImageSize(long imageSize);

	void drawIcon(Graphics *g, const IconType& iconType, const Bounds& iconRect, COLORREF color = NULL);

	long imageFileToIcon(const wstring& imageFileName);

private:

	void calculateIconRect(const Bounds& iconRect, Bounds* calculatedRect,
		float widthRatioOfHeight = 1.0,
		float heightRatioOfWidth = 1.0);
	HFONT createIconFont(Graphics *g, int iconWidth, int fontSize = -1);

	void drawAddIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawAddOnsIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawAlignmentIcon(Graphics* g, const Bounds& iconRect, const IconType& alignmentIconType, COLORREF fillColor = NULL);
	void drawAttachIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawBannerIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL,
		const std::wstring& text = L"", const std::wstring& abbrvText = L"");
	void drawBarcodeIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawBinocularIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawBusinessTypeIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawCalculatorIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawCalendarIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawCameraIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawCancelIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawCashRegisterIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawCategoryIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawCheckListIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawCheckMarkIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawClearIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawColorsIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawCommissionIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawCompanyIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawConnectionIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawContractTermsIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawCopyIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawCostBaseIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawCreditCardIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawCustomerIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawDatabaseIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawDefaultIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL,
								const std::wstring& text = L"", const std::wstring& abbrvText = L"");
	void drawDeleteIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawDepartmentIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawDiamondIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawDiskIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawDocumentIcon(Graphics* g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawDownloadIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawEditIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawEmployeeIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawEnvelopeIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawExitIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawExpensesIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawExportIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawEyeIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawFilterIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawFolderClosedIcon(Graphics* g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawFolderOpenedIcon(Graphics* g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawFuelDeliveryIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawFuelPumpIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawFuelTankIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawFuelTypeIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawGiftCardIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawHelpIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawHomeIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawImageIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawImportIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawInvoiceIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawJobTitlesIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawLayawayIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawLinkIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawLockIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawLoginIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawLogoutIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawMarketingIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawMaximizeWindowIcon(Graphics* g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawModifiersIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawMoneyBillIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawNoteIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawOKIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawPasswordIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawPaymentGatewayIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawPaymentMethodsIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawPaymentsIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawPayrollIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawPayrollHoursIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawProductIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawPromotionIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawPurchaseOrderIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawPrinterIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawQuoteIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawReceivedInventoryIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawRefreshIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawRefundsIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawRentalIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawRepairIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawReportIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawRestoreWindowIcon(Graphics* g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawReturnIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawSearchIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawServiceIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawSettingsIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawShoppingBasketIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawShowAllIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawSmsIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawSupplierIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawTagIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawTaxIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawTodoIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawTrashIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawUploadIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
	void drawUserIcon(Graphics *g, const Bounds& iconRect, COLORREF fillColor = NULL);
};
