#pragma once

#include "Component.h"

/**
 * @class Label
 * @brief A UI component for displaying text with customizable alignment.
 * 
 * The Label component displays a single line of text within its bounds.
 * Text alignment can be set to left (-1), center (0), or right (1).
 */
class Label : public Component
{
    wstring _text;       ///< The text content displayed by the label.
    long _alignment;     ///< Text alignment: -1 = left, 0 = center, 1 = right.

protected:

    /**
     * @brief Provides options needed to create the native window for the label.
     * 
     * @param title The window title (not usually visible for labels).
     * @param widownStyles The styles used to create the window.
     * @param wndClassName The window class name.
     * @param isCustomWndProc Whether to use a custom window procedure.
     * @return TRUE if options successfully provided.
     */
    BOOL getCreateWindowOptions(wstring& title, UINT& widownStyles, wstring& wndClassName, BOOL& isCustomWndProc);

    /**
     * @brief Called after the native window has been created to perform initialization.
     */
    void windowCreated();

public:

    /**
     * @brief Constructs an empty Label component.
     */
    Label();

    /**
     * @brief Destructor for Label component.
     */
    virtual ~Label();

    /**
     * @brief Sets the text content of the label.
     * 
     * @param text The new text to display.
     */
    void setText(const wstring& text);

    /**
     * @brief Sets the text alignment within the label.
     * 
     * @param alignment Alignment value (-1 for left, 0 for center, 1 for right).
     */
    void setAlignment(long alignment);

public: // Overridables

    void onPaint(Graphics* g) override;
    void onWindowResized() override;
};
