#pragma once

#include "Common.h"

enum SortType
{
    ASCENDING = 1,
    DESCENDING = 2,
    NONE = 3
};

enum FilterOperator
{
    EQUAL = 1,
    GT = 2,
    GE = 3,
    LT = 4,
    LE = 5,
    CONTAINS = 6,
    STARTSWITH = 7,
    ENDSWITH = 8
};

class FilterValue
{
public:
    wstring fieldName;
    FilterOperator comparisonOp;
    wstring value;
};

class PagerRequest
{
public:

    long sourceComponentId;
    int pageSize;
    __int64 startRowIndex;
    wstring sortBy;
    SortType sortDirection;
    vector<FilterValue> filters;
};

class Pager
{
public:
    /**
     * Fetches a page of data.
     * @param request The pager object containing the paging info.
     * @param columnNames List of column names to fetch.
     * @param rows Output parameter to receive the fetched rows; each row is a vector of strings.
     * @param totalRowCount Output parameter to receive the total number of rows available.
     * @return TRUE if page fetch was successful, FALSE otherwise.
     */
    virtual BOOL GetPage(const PagerRequest& request,
                         const vector<wstring>& columnNames,
                         vector<vector<wstring>>& rows,
                         __int64& totalRowCount) = 0;

    virtual ~Pager() {}  // Virtual destructor for proper cleanup
};
