#pragma once

#include "./Common.h"

class PopupMenuItem
{
public:
    long _actionId;  
    wstring _text;   
    BOOL _isSeparator;
};

/**
 * @brief Represents a popup (context) menu.
 */
class PopupMenu
{
    std::vector<PopupMenuItem> _menuItems; /**< List of menu items */

public:
    /**
     * @brief Constructs an empty PopupMenu.
     */
    PopupMenu();

    /**
     * @brief Virtual destructor to clean up resources.
     */
    virtual ~PopupMenu();

    /**
     * @brief Adds a regular menu item.
     * 
     * @param actionId Action identifier associated with this menu item.
     * @param text Display text for the menu item.
     */
    void addItem(long actionId, const wstring& text);

    /**
     * @brief Adds a separator item to the menu.
     */
    void addSeparator();

    /**
     * @brief Displays the popup menu at the specified screen coordinates.
     * 
     * @param hWnd Handle to the owner window.
     * @param x X coordinate (screen pixels) where the menu should appear.
     * @param y Y coordinate (screen pixels) where the menu should appear.
     * 
     * @return long The actionId of the selected menu item, or -1 if no selection.
     */
    long showMenu(WinHandle hWnd, long x, long y);
};
