#pragma once

#include "Component.h"

/**
 * @class ProgressBar
 * @brief A UI component that represents a checkable box with optional label text.
 *
 * Inherits from Component and allows users to toggle a boolean state (checked/unchecked).
 * Supports event listeners for selection change.
 */
class ProgressBar : public Component
{
	int _value;

protected:
	/**
	 * @brief Retrieves options for creating the checkbox window.
	 *
	 * @param title Output: window title.
	 * @param widownStyles Output: window style flags.
	 * @param wndClassName Output: class name of the window.
	 * @param isCustomWndProc Output: whether a custom window procedure is used.
	 * @return TRUE if the options were successfully retrieved, FALSE otherwise.
	 */
	BOOL getCreateWindowOptions(wstring& title, UINT& widownStyles, wstring& wndClassName, BOOL& isCustomWndProc);

	/**
	 * @brief Called after the checkbox window has been successfully created.
	 */
	void windowCreated();

public:
	/**
	 * @brief Constructs a new ProgressBar component.
	 */
	ProgressBar();

	/**
	 * @brief Destroys the ProgressBar component.
	 */
	virtual ~ProgressBar();

	/**
	 * @brief Returns the preferred height
	 */
	int getPreferredHeight();

	/**
	 * @brief Sets the current value.
	 *
	 * @param value The text to display.
	 */
	void setValue(int value);

	/**
	 * @brief Returns the current value.
	 */
	int getValue();

public: // Overridables

	void onPaint(Graphics *g) override;
	void onWindowResized() override;
};
