#pragma once

#include "Component.h"

class ScrollbarListener
{
public:

    virtual void scrollBarActivity(__int64 firstVisibleItem) = 0;
    virtual void scrollBarRepaint() = 0;
};

class Scrollbar
{
    Bounds _sbRect, _thumbRect, _upArrowRect, _downArrowRect;
    __int64 _totalItemCount;
    __int64 _firstVisibleItem;
    long _pageSize;

    ScrollbarListener* _listener;

    wstring _clickedButton;
    long _thumbLastHitY;

    HDWP _hDwp;

private:

    void thumbPosToRow(int thumbPos);

public:

    Scrollbar();
    virtual ~Scrollbar();

    long getVScrollbarWidth();
    long getHScrollbarHeight();

    void paint(Graphics* g, const Bounds& rect, __int64 totalItemCount, __int64 firstVisibleItem, long maxVisibleItems);

    BOOL onMousePressed(WinHandle hWnd, int x, int y, int clickCount, BOOL shiftPressed, BOOL ctrlPressed);
    BOOL onMouseReleased(WinHandle hWnd, int x, int y, BOOL shiftPressed, BOOL ctrlPressed);
    BOOL onMouseMoved(WinHandle hWnd, int x, int y, BOOL shiftPressed, BOOL ctrlPressed);

    void addListener(ScrollbarListener* l);
};
