#pragma once

#include "Component.h"

class Slider : public Component
{
    long _rangeMin;
    long _rangeMax;
    long _value;
    BOOL _showTooltip;

    double _tickValue;

    Bounds _thumbRect;
    BOOL _isDragging;

protected:
    BOOL getCreateWindowOptions(wstring& title, UINT& widownStyles, wstring& wndClassName, BOOL& isCustomWndProc);

    void windowCreated();

public:
    Slider();

    virtual ~Slider();

    int getPreferredHeight();

    void setRange(long rangeMin, long rangeMax);

    void setValue(long value);
    long getValue();

    void showTooltip(BOOL bShow = TRUE);

    void onPaint(Graphics* g);

    void onWindowResized();

    void onMousePressed(WinHandle hWnd, int x, int y, int clickCount, BOOL shiftPressed, BOOL ctrlPressed);
    void onMouseReleased(WinHandle hWnd, int x, int y, BOOL shiftPressed, BOOL ctrlPressed);
    void onMouseMoved(WinHandle hWnd, int x, int y, BOOL shiftPressed, BOOL ctrlPressed);
    void onSelectionChanged(WinHandle hWndCB, int newValue, const wstring& itemText, BOOL itemChecked, const ProcParams& procParams);

    void addSelectionChangedListener(SelectionChangeListener* l);
};

/* WINDOWS NATIVE SLIDER
#pragma once

#include "Component.h"

class Slider : public Component
{
    long _rangeMin;    
    long _rangeMax;    
    long _tickFrequency;
    long _value;        

protected:

    BOOL getCreateWindowOptions(wstring& title, UINT& widownStyles, wstring& wndClassName, BOOL& isCustomWndProc);

    void windowCreated();

public:

    Slider();

    virtual ~Slider();

    int getPreferredHeight();

    void setRange(long rangeMin, long rangeMax);

    void setTickMarksFrequency(long frequency);

    void setValue(long value);

    long getValue();

    void onSelectionChanged(WinHandle hWndCB, int newValue, const wstring& itemText, BOOL itemChecked, const ProcParams& procParams);

    void addSelectionChangedListener(SelectionChangeListener* l);
};
*/
