#pragma once

#include "Component.h"

/**
 * @class ToolTip
 * @brief A UI component for displaying tooltips.
 * USAGE:
 *
	_tooltip.createComponent(this, { 0,0,0,0 });
    _tooltip.setText(L"Tooltip Text");
    _tooltip.show(getWindowHandle(), 0,0);
 */
class ToolTip : public Component
{
	/**
	 * @brief The tooltip text
	 */
	wstring _text;
	ButtonType _color;

protected:

	/**
	 * @brief Retrieves options needed to create the tooltip window.
	 *
	 * @param title The window title.
	 * @param widownStyles The style flags for the window.
	 * @param wndClassName The class name of the window.
	 * @param isCustomWndProc Whether a custom window procedure is used.
	 * @return TRUE if successful, FALSE otherwise.
	 */
	BOOL getCreateWindowOptions(wstring& title, UINT& widownStyles, wstring& wndClassName, BOOL& isCustomWndProc);

	/**
	 * @brief Called after the window has been successfully created.
	 */
	void windowCreated();

public:

	/**
	 * @brief Constructs a ToolTip component.
	 */
	ToolTip();

	/**
	 * @brief Destroys the ToolTip component.
	 */
	virtual ~ToolTip();

	/**
	 * @brief Sets the text and colors of the tooltip.
	 */
	void setInfo(const wstring& text, const ButtonType& color = ButtonType::INFO);

	/**
	 * @brief Shows the tooltip at position.
	 */
	void show(Component *parent, int width = 200, int height = 70);

	/**
	 * @brief Hides the tooltip
	 */
	void hide();

	/**
	 * @brief Gets the text of the tooltip.
	 */
	wstring getText();

public: // Overridables

	/**
	 * @brief Paints the tooltip to the provided device context.
	 *
	 * @param hDC Handle to the device context.
	 */
	void onPaint(Graphics *g);

	/**
	 * @brief Called when the window has been resized.
	 */
	void onWindowResized();

	/**
	 * @brief Handles mouse press events.
	 *
	 * @param hWnd Handle to the window receiving the event.
	 * @param x The x-coordinate of the mouse event.
	 * @param y The y-coordinate of the mouse event.
	 * @param clickCount Number of mouse clicks.
	 * @param shiftPressed Whether the Shift key is pressed.
	 * @param ctrlPressed Whether the Ctrl key is pressed.
	 */
	void onMousePressed(WinHandle hWnd, int x, int y, int clickCount, BOOL shiftPressed, BOOL ctrlPressed);

	void onTimer(unsigned int timerId);
};
