#pragma once

#include "Common.h"
#include "Theme.h"
#include "Models.h"

#define STANDARD_FONT_NAME	L"Arial"
#define STANDARD_FONT_SIZE	12

/**
 * @brief Utility class providing common UI helper functions for font management,
 *        drawing, and window visibility.
 */
class UICommonUtils
{
    static UINT NextId; /**< Internal counter for generating unique IDs */

public:
    /**
     * @brief Retrieves the screen size in pixels.
     * @param width Reference to variable to receive screen width.
     * @param height Reference to variable to receive screen height.
     */
    static void getScreenSize(long& width, long& height);

    /**
     * @brief Makes a window visible.
     * @param hWnd Handle to the window.
     */
    static void setWindowVisible(WinHandle hWnd);

    /**
     * @brief Hides a window.
     * @param hWnd Handle to the window.
     */
    static void setWindowHidden(WinHandle hWnd);

    /**
     * @brief The following functions manage windows updates throttling.
     */
    static void redrawWindow(WinHandle hWnd);

    /**
     * @brief Processes common window procedure subclassing functionality.
     * @param hWnd Handle to the window.
     * @param msg Windows message code.
     * @param wParam Additional message information.
     * @param lParam Additional message information.
     * @return TRUE if the message was processed; FALSE otherwise.
     */
    static BOOL processCommonWndProcSubclassingFunctionality(WinHandle hWnd, UINT msg, WPARAM wParam, LPARAM lParam);

public:
    /**
     * @brief Creates a custom font.
     * @param hDC Device context handle.
     * @param fontName Name of the font (e.g., L"Arial").
     * @param fontSize Size of the font in points.
     * @param isBold Whether the font should be bold.
     * @param isItalic Whether the font should be italic.
     * @param isUnderlined Whether the font should be underlined.
     * @return Handle to the created font (HFONT).
     */
    static HFONT CreateCustomFont(DCHandle hDC, const wstring& fontName, int fontSize, BOOL isBold = FALSE, BOOL isItalic = FALSE, BOOL isUnderlined = FALSE);

    static BOOL calculateMaxVisibleItems(__int64 availableHeight, __int64 itemHeight, __int64 totalItemCount,
        __int64 firstVisibleItem, __int64& lastVisibleItem,
        long& maxVisibleItems, BOOL& lastItemIsPartiallyDisplayed, BOOL& isVScrollbarVisible);
};
