#pragma once

#include "CardPanel.h"
#include "Button.h"

class WizardActionListener
{
public:

    virtual void onFinish() = 0;
    virtual void onCancel() = 0;
};

/**
 * @brief A component that manages multiple panels with associated content components.
 */
class Wizard: public Component, public ActionListener
{
    WinHandle _hWnd;                 /**< Window handle */
    CardPanel _cardPanel;       /**< Panel managing tab content */
    
    WizardActionListener* _listener;

    Button _backButton, _nextButton;

    long _buttonsRowHeight;

    vector<Component *> _panels;   /**< List of panels */
    long _currentIndex;      /**< Index of the currently shown panel */

protected:
    /**
     * @brief Retrieves window creation options.
     * 
     * @param title Reference to window title.
     * @param widownStyles Reference to window styles.
     * @param wndClassName Reference to window class name.
     * @param isCustomWndProc Reference to custom window procedure flag.
     * @return TRUE if successful, FALSE otherwise.
     */
    BOOL getCreateWindowOptions(wstring& title, UINT& widownStyles, wstring& wndClassName, BOOL& isCustomWndProc);

    /**
     * @brief Called when the window is created.
     */
    void windowCreated();

public:
    /**
     * @brief Constructs a new Wizard component.
     */
    Wizard();

    /**
     * @brief Destructor for the Wizard component.
     */
    virtual ~Wizard();

    void setListener(WizardActionListener* l);

    /**
     * @brief Clears all panels.
     */
    void clear();

    /**
     * @brief Adds a new tab with the specified title and component.
     * 
     * @param tabTitle The title of the tab.
     * @param tabComponent The component to display when the tab is active.
     */
    void addPanel(Component* component);

    /**
     * @brief Handles window resize events.
     */
    void onWindowResized();

    /**
     * @brief Paints the Wizard including panels and active content.
     * 
     * @param hDC Device context handle.
     */
    void onPaint(Graphics *g);

    void onAction(const ActionEvent& ev);
};
